﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace MelcoAPI_CSharpWeb.API
{
    public partial class Designs : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

            string format =Request["Format"]==null?string.Empty:Request["Format"].ToString();
            string Env = Request["env"].ToString();
            string UserName = Request["User"].ToString();
            string APIKey = Request["Key"].ToString();
            string Method = Request["Method"].ToString();
            
            string ContentType = "";

            string rtnStr = string.Empty;
            byte[] rtnImage = null;

            try
            {

                if (Method.ToLower() == "GetList".ToLower())
                {
                    ContentType = "data";
                    string Url = "/" + Uri.EscapeUriString(UserName) + "/Designs/GetList?format=" + format;
                    Url = Melco.Util.GetServerUrl(Env) + Url + "&LDFAuth=" + Melco.Auth.GetAuthString(UserName, APIKey, Url);
                    rtnStr = Melco.Util.ExecuteWebRequest(Url, "GET", string.Empty);
                }
                if (Method.ToLower() == "GetDefinition".ToLower())
                {
                    ContentType = "data";
                    string ReferenceID=Request["ReferenceID"].ToString();
                    string Url = "/" + Uri.EscapeUriString(UserName) + "/Designs/GetDefinition?ReferenceID="+ReferenceID+"&format=" + format;
                    Url = Melco.Util.GetServerUrl(Env) + Url + "&LDFAuth=" + Melco.Auth.GetAuthString(UserName, APIKey, Url);
                    rtnStr = Melco.Util.ExecuteWebRequest(Url, "GET", string.Empty);
                }
                if (Method.ToLower() == "GetImage".ToLower())
                {
                    ContentType = "image";
                    string ReferenceID = Request["ReferenceID"].ToString();
                    string Url = "/" + Uri.EscapeUriString(UserName) + "/Designs/GetImage?ReferenceID=" + ReferenceID + "&format=" + format;
                    Url = Melco.Util.GetServerUrl(Env) + Url + "&LDFAuth=" + Melco.Auth.GetAuthString(UserName, APIKey, Url);
                    rtnImage = Melco.Util.ExecuteImageWebRequest(Url);
                }
            }
            catch (Exception ex)
            {
                Response.Write("<b>" + ex.StackTrace + "</b>");
                Response.End();
            }




            //response
            if (ContentType == "data")
            {
                if (format.ToLower() == "xml")
                    Response.ContentType = "text/xml";
                else
                    Response.ContentType = "application/json";
                Response.Write(rtnStr);
            }
            else if (ContentType == "image")
            {
                Response.ContentType = "image/png";
                Response.BinaryWrite(rtnImage);
            }
            else if (ContentType == "file")
            {
                Response.ContentType = "application/octet-stream";
                Response.BinaryWrite(rtnImage);
            }
            

        }
        
    }
}