﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace MelcoAPI_CSharpWeb.api
{
    public partial class Tokens : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            string ContentType =string.Empty,FileName = string.Empty;

            string format = Request["Format"] == null ? string.Empty : Request["Format"].ToString();
            string Env = Request["env"].ToString();
            string UserName = Request["User"].ToString();
            string APIKey = Request["Key"].ToString();
            string Method = Request["Method"].ToString();
          
            
            string rtnStr = string.Empty;
            byte[] rtnImage = null;

            try
            {

                if (Method.ToLower() == "GetFulfilmentDetails".ToLower())
                {
                    ContentType = "data";
                    string Token = Request["Token"].ToString();
                    string Url = "/" + Uri.EscapeUriString(UserName) + "/TokenFulfillment/GetDefinition?Token="+Token+"&format=" + format;
                    Url += "&embFormat=OFM&vectorFormat=SVG&DPI=300";
                    Url = Melco.Util.GetServerUrl(Env) + Url + "&LDFAuth=" + Melco.Auth.GetAuthString(UserName, APIKey, Url);
                    rtnStr = Melco.Util.ExecuteWebRequest(Url, "GET", string.Empty);
                }
                if (Method.ToLower() == "GetImage".ToLower())
                {
                    ContentType = "image";
                    string Token = Request["Token"].ToString();
                    string Url = "/" + Uri.EscapeUriString(UserName) + "/Token/GetImage?Token=" + Token;
                    Url += "&ThumbnailWidth=200";
                    Url = Melco.Util.GetServerUrl(Env) + Url +"&LDFAuth=" + Melco.Auth.GetAuthString(UserName, APIKey, Url);
                    rtnImage = Melco.Util.ExecuteImageWebRequest(Url);
                }
                if (Method.ToLower() == "GetFulfillmentFiles".ToLower())
                {
                    string Token = Request["Token"].ToString();
                    ContentType = "file";
                    FileName = Token + ".zip";
                    
                    string Url = "/" + Uri.EscapeUriString(UserName) + "/TokenFulfillment/GetArchive?Token=" + Token + "&format=" + format;
                    Url += "&embFormat=OFM&vectorFormat=SVG&DPI=300";
                    Url = Melco.Util.GetServerUrl(Env) + Url + "&LDFAuth=" + Melco.Auth.GetAuthString(UserName, APIKey, Url);
                    rtnImage = Melco.Util.ExecuteImageWebRequest(Url);
                }
            }
            catch (Exception ex)
            {
                Response.Write("<b>" + ex.StackTrace + "</b>");
                Response.End();
            }




            //response
            if (ContentType == "data")
            {
                if (format.ToLower() == "xml")
                    Response.ContentType = "text/xml";
                else
                    Response.ContentType = "application/json";
                Response.Write(rtnStr);
            }else if(ContentType=="image")
            {
                Response.ContentType = "image/png";
                if(rtnImage!=null)Response.BinaryWrite(rtnImage);
            }
            else if (ContentType == "file")
            {
                Response.AddHeader("content-disposition", string.Format("attachment; filename={0}", FileName));
                Response.ContentType = "application/octet-stream";
                if (rtnImage != null) Response.BinaryWrite(rtnImage);
            }
            

            
                
        }
    }
}