﻿function APIKeyToUpper() {
    $('#txtApiKey').val($('#txtApiKey').val().toUpperCase());
}
function html5upload() {
	return $("<input type='file'>").get(0).files !== undefined; 
}
function getDocUrl() {
    var env = getEnvironment();
    if (env == 'production') {
        return 'https://admin.livedesignerfusion.com';
    } else if (env == 'development') {
        return 'http://dev-client.livedesignerfusion.com';
    }
    return 'http://sandbox-admin.livedesignerfusion.com';
}

function getServerUrl() {
	var env=getEnvironment();
	if (env== 'production'){
		return 'http://client.livedesignerfusion.com';
	}else if(env == 'development'){
		return 'http://dev-client.livedesignerfusion.com';
	}
	return 'http://sandbox-client.livedesignerfusion.com';
}


function showData(data){
	$('#dataDialog').empty();
	var strData='';
	if(getFormat()=='xml'){
		strData= data;
		strData=strData.replace(/>/g,"&gt;").replace(/</g,"&lt;");
		$('#dataDialog').append('<pre class="brush: xml; auto-links: false">' + strData + '</pre>');
	}else{
		strData=JSON.stringify(data,null, '\t');
		strData=strData.replace(/>/g,"&gt;").replace(/</g,"&lt;");
		$('#dataDialog').append('<pre class="brush: js; auto-links: false">' + strData + '</pre>');
	}
	SyntaxHighlighter.highlight();
}
function setupUpload(controlName,apiName,methodName){
	var browser_support =html5upload();
	if (browser_support) {
		var url = '/api/auth.php?APIName='+apiName+'&MethodName='+methodName+'&User=' + getUser() + '&Key=' + getApiKey() + '&Env=' + getEnvironment() + '&Format=' + getFormat();
		$.ajax({
			url: url
		}).done(function(data) {
			var url1=getServerUrl()+'/'+getUser() +'/'+apiName+'/'+methodName+'?Format='+getFormat()+'&LDFAuth='+data.auth;
			$('#'+controlName).fileupload({
				url: url1,
				singleFileUploads: true,
				done: function (e, data1) {
					if (data1.jqXHR.responseText || data1.result) {
						var res = (data1.jqXHR.responseText) ? jQuery.parseJSON(data1.jqXHR.responseText) : data1.result;
						showData(res);
						$('#resultsDialog').dialog('open');
					}
				}
			})
			.bind('fileuploadsubmit', function (e, data) {})	
			.bind('fileuploadprogress', function (e, data) {})
			.bind('fileuploadfail', function (e, data) {alert('File Upload Failed')});
			//alert($('#'+controlName).fileupload('option','url'));
		});
	} else {
	  alert('upload functions are not supported by browser use latest browser');
	}
}

function createUpload(){
	setupUpload('designUpload','Designs','Upload');
	setupUpload('fontUpload','Fonts','Upload');
	setupUpload('styleUpload','Styles','Upload');
}
function createDocLinks() {
    $(".docLink").each(function (index) {
        var src = getDocUrl() + $('span', this.parent).html();
        $(this).attr('href', src);
    });
}
$(document).ready(function () {
    $('#txtApiKey').keyup(APIKeyToUpper).keydown(APIKeyToUpper);
	$('#txtApiKey,#txtUserName').change(createUpload);
	$('.env').click(function () {
        alert('Please update your username/api key for selected environment. It might be different in sandbox vs production.');
        createUpload();
        createDocLinks();
    });
	$('.format').click(createUpload);
	
    // Wire up tabs
    $('#tabs').tabs({
        select: function (event, ui) {
            //saveSelectedTab(ui.index);
        }
    });
    //$('#tabs').tabs({ selected: 7 });

    // Wire up the results dialog
    $('#resultsDialog').dialog({
        autoOpen: false,
        resizable: false,
        modal: true,
        closeOnEscape: true,
        position: 'center',
        draggable: true,
        width: 750,
        height: 500
    });
    createUpload();
    createDocLinks();
	
});

function validateInputs() {
    if ($('#txtUserName').val().length == 0) {
        alert('Please enter a User Name.');
        return false;
    }
    if ($('#txtApiKey').val().length == 0) {
        alert('Please enter an API Key.');
        return false;
    }
    return true;
}
function loadUrl(url) {
	$('#imageDialog').empty();
	$('#dataDialog').empty().append('<span>Loading</span>');
	$.ajax({
		url: url
	}).done(function(data) {
		showData(data);
	});
    $('#resultsDialog').dialog('open');
}
function loadImageUrl(url) {
	$('#imageDialog').empty().append('<span>Loading</span>');
	$('#dataDialog').empty()
	$.ajax({
		url: url
	}).done(function(data) {
		//$('#imageDialog').empty().append(data);
		var img=$(data).load(function() { 
		  $('#imageDialog').empty().append(img);
        })
	});
    $('#resultsDialog').dialog('open');
}
function loadFileUrl(url) {
	$('#imageDialog,#dataDialog').empty();
	$('#imageDialog').append('<iframe width="700" height="425" src="' + url + '"></iframe>');
    //$('#resultsDialog').dialog('open');
}

function getUser() { return $('#txtUserName').val(); };
function getApiKey() { return $('#txtApiKey').val(); };
function getEnvironment() {
    if (($('#rEnvProduction').attr("checked") != "undefined" && $('#rEnvProduction').attr("checked") == "checked")) {
        return 'production';
    } else if (($('#rEnvDev').attr("checked") != "undefined" && $('#rEnvDev').attr("checked") == "checked")) {
        return 'development';
    } else {
        return 'sandbox';
    }
}
function getFormat() {
    if (($('#rFormatXml').attr("checked") != "undefined" && $('#rFormatXml').attr("checked") == "checked")) {
        return 'xml';
    } else {
        return 'json';
    }
}

//execute all data api calls (xml,json)
function executeData(apiName,methodname) {
    if (!validateInputs()) return;
	var url = '';
	var params='';
	url = '/api/data.php?APIName='+apiName+'&MethodName='+ methodname+'&User=' + getUser() + '&Key=' + getApiKey() + '&Env=' + getEnvironment() + '&Format=' + getFormat();
	switch (apiName) {
		case 'DesignCollections':
				switch (methodname) {
					case 'GetList':break;
					case 'Create':
						url += '&Params='+encodeURIComponent('Name='+$('#txtDCName').attr('value'));	
						break;
					case 'Delete':
						url += '&Params='+encodeURIComponent('ReferenceID='+$('#txtDCReferenceID').attr('value'));	
						break;
					case 'Add':
						params='ReferenceID='+$('#txtDCAddReferenceID').attr('value');
						params+='&Designs='+$('#txtDCAddDesigns').attr('value');
						url += '&Params='+encodeURIComponent(params);	
						break;
					case 'Remove':
						params='ReferenceID='+$('#txtDCAddReferenceID').attr('value');
						params+='&DesignReferenceID='+$('#txtDCAddDesigns').attr('value');
						url += '&Params='+encodeURIComponent(params);	
						break;
				} 
			break;
		case 'Designs':
			switch (methodname) {
					case 'GetList':break;
					case 'GetDefinition':
					case 'Delete':
					case 'GetMetaData':					
						url += '&Params='+encodeURIComponent('ReferenceID='+$('#txtDesignReferenceID').attr('value'));	
						break;
				} 
			break;
		case 'FontCollections':
				switch (methodname) {
					case 'GetList':break;
					case 'Create':
						url += '&Params='+encodeURIComponent('Name='+$('#txtFCName').attr('value'));	
						break;
					case 'Delete':
						url += '&Params='+encodeURIComponent('ReferenceID='+$('#txtFCReferenceID').attr('value'));	
						break;
					case 'Add':
						params='ReferenceID='+$('#txtFCAddReferenceID').attr('value');
						params+='&FontList='+$('#txtFCAddDesigns').attr('value');
						url += '&Params='+encodeURIComponent(params);	
						break;
					case 'Remove':
						params='ReferenceID='+$('#txtFCAddReferenceID').attr('value');
						params+='&FontReferenceID='+$('#txtFCAddDesigns').attr('value');
						url += '&Params='+encodeURIComponent(params);	
						break;
				} 
			break;	
		case 'Fonts':
				switch (methodname) {
					case 'GetList':break;
					case 'GetDefinition':
					case 'Delete':
						url += '&Params='+encodeURIComponent('ReferenceID='+$('#txtFontReferenceID').attr('value'));	
						break;
				} 
			break;
		case 'ColorCollections':
			switch (methodname) {
				case 'GetList':
					var service=$('#listEmroidery').is(':checked')?'embroidery':'printing';
					url += '&Params='+encodeURIComponent('Service='+service);	
				break;
				case 'Create':
					var service=$('#createEmroidery').is(':checked')?'embroidery':'printing';
					url += '&Params='+encodeURIComponent('Service='+service+'&Name='+$('#txtCCName').attr('value'));	
					break;
				case 'Add':
				case 'Remove':
						params='ReferenceID='+$('#txtCCAddReferenceID').attr('value');
						params+='&ColorReferenceID='+$('#txtCCAddColors').attr('value');
						url += '&Params='+encodeURIComponent(params);	
						break;	
				case 'Delete':
				case 'GetDefinition':
						url += '&Params='+encodeURIComponent('ReferenceID='+$('#txtCCReferenceID').attr('value'));	
						break;
				
				
				} 
			break;
		case 'Color':
				switch (methodname) {
					case 'GetList':
						url += '&Params='+encodeURIComponent('ReferenceID='+$('#txtCLReferenceID').attr('value'));	
					break;
				} 
			break;
		case 'Styles':
			switch (methodname) {
				case 'GetList':
					var defaultStyle=$('#chkDefaultStyles').is(':checked')?'true':'false';
					url += '&Params='+encodeURIComponent('DefaultStyle='+defaultStyle);	
					break;
				case 'GetDefinition':
				case 'Delete':
						url += '&Params='+encodeURIComponent('ReferenceID='+$('#txtSReferenceID').attr('value'));	
						break;
			} 
			break;	
		case '1':
			break;
	} 
    
	 

    /*if (methodname == 'GetImage') {
        if ($('#txtDesignReferenceID').attr('value').length == 0) {
            alert('Please enter a Design ReferenceID.');
            return;
        }
        url = urlPrefix + '/api/designs.php?User=' + GetUser() + '&Key=' + GetApiKey() + '&Env=' + GetEnvironment() + '&Format=' + GetFormat() + '&Method=GetImage';
        url += '&ReferenceID=' + $('#txtDesignReferenceID').attr('value');
    }*/

    loadUrl(url);
}
function executeImage(apiName,methodname) {
    if (!validateInputs()) return;
	var url = '';
	var params='';
	url = '/api/image.php?APIName='+apiName+'&MethodName='+ methodname+'&User=' + getUser() + '&Key=' + getApiKey() + '&Env=' + getEnvironment();
	switch (apiName) {
		case 'Designs':
			switch (methodname) {
				case 'GetImage':
					url += '&Params='+encodeURIComponent('ReferenceID='+$('#txtDesignReferenceID').attr('value'));break;
				case 'GetThumbnail':
					url += '&Params='+encodeURIComponent('Width=200&ReferenceID='+$('#txtDesignReferenceID').attr('value'));break;
			} 
			break;
		case 'Fonts':
			switch (methodname) {
				case 'GetImage':
					url += '&Params='+encodeURIComponent('ReferenceID='+$('#txtFontReferenceID').attr('value'));break;
				case 'GetThumbnail':
					url += '&Params='+encodeURIComponent('ReferenceID='+$('#txtFontReferenceID').attr('value'));break;
			} 
			break;
		case 'Letterings':
			switch (methodname) {
				case 'GetImage':
					var p='Text='+$('#txtltrText').attr('value');
					p+='&Alphabet='+$('#txtFont').attr('value');
					p+='&Height='+$('#txtltrHeight').attr('value');
					p+='&Color='+$('#ddTextColor').val();
					p+='&BaseLineType='+$('#ddBaseline').val();
					p+='&ArcRad='+$('#txtArcRad').attr('value');
					p+='&CCW='+$('#ddCCW').attr('value');
					p+='&rot='+$('#ddRotation').attr('value');
					url+= '&Params='+encodeURIComponent(p);
				break;
				
			} 
			break;
	} 
    loadImageUrl(url);
}
function executeFile(apiName,methodname) {
    if (!validateInputs()) return;
	var url = '';
	var params='';
	url = '/api/file.php?APIName='+apiName+'&MethodName='+ methodname+'&User=' + getUser() + '&Key=' + getApiKey() + '&Env=' + getEnvironment();
	switch (apiName) {
		case 'Designs':
			switch (methodname) {
				case 'GetFile':
					var fileName=$('#txtDFileName').attr('value');
					url += '&Params='+encodeURIComponent('FileName='+fileName+'&ReferenceID='+$('#txtDDReferenceID').attr('value'));	
					url+='&FileName='+fileName;
					break;
			} 
			break;
		case 'Fonts':
			switch (methodname) {
				case 'GetFile':
					url += '&Params='+encodeURIComponent('ReferenceID='+$('#txtFontReferenceID').attr('value'));	
					break;
			} 
			break;
		case 'ColorCollections':
			switch (methodname) {
				case 'GetColorFile':
					url+= '&Params='+encodeURIComponent('FileName=Colors.clr&ReferenceID='+$('#txtCCReferenceID').attr('value'));	
					url+='&FileName=Colors.clr';
					break;
			} 
			break;			
		case 'Styles':
			switch (methodname) {
				case 'GetFile':
					url+= '&Params='+encodeURIComponent('FileName=Style.ST3&ReferenceID='+$('#txtSReferenceID').attr('value'));	
					url+='&FileName=Style.ST3';
					break;
			} 
			break;
		case '1':
			break;
	} 
	loadFileUrl(url);
}





function ExecuteTokens(methodname) {

    if (!ValidateRequiredElements()) return;

    var url = '';

    if ($('#txtToken').attr('value').length == 0) {
        alert('Please enter a Personalization Token Value.');
        return;
    }

    if (methodname == 'GetFulfilmentDetails') {
        url = urlPrefix + '/api/tokens.php?User=' + GetUser() + '&Key=' + GetApiKey() + '&Env=' + GetEnvironment() + '&Format=' + GetFormat() + '&Method=GetFulfilmentDetails';
        url += '&Token=' + $('#txtToken').attr('value');
    }

    if (methodname == 'GetImage') {
        url = urlPrefix + '/api/tokens.php?User=' + GetUser() + '&Key=' + GetApiKey() + '&Env=' + GetEnvironment() + '&Format=' + GetFormat() + '&Method=GetImage';
        url += '&Token=' + $('#txtToken').attr('value');
    }

    if (methodname == 'GetFulfillmentFiles') {
        url = urlPrefix + '/api/tokens.php?User=' + GetUser() + '&Key=' + GetApiKey() + '&Env=' + GetEnvironment() + '&Format=' + GetFormat() + '&Method=GetFulfillmentFiles';
        url += '&Token=' + $('#txtToken').attr('value');
    }

    LoadUrl(url);
}




