﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace MelcoAPI_CSharpWeb.api
{
    public partial class file : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            string apiName = Request["APIName"];
            string methodName = Request["methodName"];
            string UserName = Request["User"].ToString();
            string APIKey = Request["Key"].ToString();
            string Env = Request["env"].ToString();
            string format = Request["Format"] == null ? string.Empty : Request["Format"].ToString();
            string param = Request["Params"] == null ? string.Empty : Request["Format"].ToString();
            string FileName = Request["FileName"].ToString();

            if (param.Length > 0)
            {
                param = Server.UrlDecode(param);

            }
            string url = "/" + UserName + "/" + apiName + "/" + methodName + "?Format=" + format + "&" + param;
            url = Melco.Util.GetServerUrl(Env) + url + "&LDFAuth=" + Melco.Auth.GetAuthString(UserName, APIKey, url);

            Response.ContentType = "Content-Type: application/octet-stream";
            Response.AddHeader("content-disposition", string.Format("attachment; filename={0}", FileName));
            Response.Write("<img src=\""+ url +"\" />");
        }
    }
}