﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace MelcoAPI_CSharpWeb.api
{
    public partial class data : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

            string apiName = Request["APIName"];
            string methodName = Request["methodName"];
            string UserName = Request["User"].ToString();
            string APIKey = Request["Key"].ToString();
            string Env = Request["env"].ToString();
            string format = Request["Format"] == null ? string.Empty : Request["Format"].ToString();
            string param = Request["Params"] == null ? string.Empty : Request["Params"].ToString();

            if(param.Length>0)
            {
                param=Server.UrlDecode(param);
            
            }
            string url = "/" + UserName + "/" + apiName + "/" + methodName + "?Format=" + format+(param.Length>0?"&":"")+ param;
            url =Melco.Util.GetServerUrl(Env)+ url+ "&LDFAuth="+ Melco.Auth.GetAuthString(UserName,APIKey,url);
            
            string data=Melco.Util.ExecuteWebRequest(url,"GET","");
            if (format.ToLower() == "xml") {
		        Response.ContentType="Content-Type: text/plain";
	        } else {
                Response.ContentType="Content-Type: application/json";
            }
            Response.Write(data);
        }
    }
}